% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kantorovich_ompr.R
\name{kantorovich_ompr}
\alias{kantorovich_ompr}
\title{Computes Kantorovich distance with 'ompr'}
\usage{
kantorovich_ompr(mu, nu, dist, solution = FALSE, stop_if_fail = TRUE)
}
\arguments{
\item{mu}{(row margins) probability measure in numeric mode}

\item{nu}{(column margins) probability measure in numeric mode}

\item{dist}{matrix defining the distance to be minimized on average}

\item{solution}{logical; if \code{TRUE} the solution is returned in the
\code{"solution"} attributes of the output}

\item{stop_if_fail}{logical; if \code{TRUE}, an error is returned in the
case when no solution is found; if \code{FALSE}, the output of
\code{\link[ompr]{solve_model}} is returned with a warning}
}
\description{
Kantorovich distance using the \code{ompr} package
}
\note{
The \code{glpk} solver is the one used to solve the problem.
}
\examples{
x <- c(1.5, 2, -3)
mu <- c(1/7, 2/7, 4/7)
y <- c(-4, 3.5, 0)
nu <- c(1/4, 1/4, 1/2)
M <- outer(x, y, FUN = function(x, y) abs(x - y))
kantorovich_ompr(mu, nu, dist = M)

}
