% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/khis_cred.R
\name{khis_cred}
\alias{khis_cred}
\title{Sets DHIS2 Credentials}
\usage{
khis_cred(
  username = NULL,
  password = NULL,
  server = NULL,
  api_version = NULL,
  config_path = NULL,
  base_url = deprecated()
)
}
\arguments{
\item{username}{The DHIS2 username. Only required if configuration file not
provided.}

\item{password}{The DHIS2 password. Only required if configuration file not
provided.}

\item{server}{The server URL of the DHIS2 instance. Only required if configuration
file not provided.}

\item{api_version}{The API version of the DHIS2 instance (optional).}

\item{config_path}{An optional path to a configuration file containing username
and password. This is considered more secure than providing credentials directly
in code.}

\item{base_url}{Deprecated. The base URL of the DHIS2 instance. Use \code{server} instead.}
}
\value{
Auth object
}
\description{
\code{khis_cred()} sets the credentials for accessing a DHIS2 instance.
}
\details{
This function allows you to set the credentials for interacting with a DHIS2
server. You can either provide the username and password directly (less secure)
or specify a path to a configuration file containing these credentials. Using
a configuration file is recommended for improved security as it prevents
credentials from being stored directly in your code.
}
\examples{

\dontrun{
    # Option 1: Using a configuration file (recommended)
    # Assuming a configuration file named "credentials.json":
    khis_cred(config_path = "path/to/credentials.json")

    # Option 2: Providing credentials directly (less secure)
    khis_cred(username = "your_username",
              password = "your_password",
              base_url='https://dhis2-instance/api')
}
}
\seealso{
Other credential functions: 
\code{\link{khis_base_url}()},
\code{\link{khis_cred_clear}()},
\code{\link{khis_display_name}()},
\code{\link{khis_has_cred}()},
\code{\link{khis_username}()}
}
\concept{credential functions}
