% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-estimation-kernel-density.R
\name{kld_est_kde}
\alias{kld_est_kde}
\title{Kernel density-based Kullback-Leibler divergence estimation in any dimension}
\usage{
kld_est_kde(X, Y, hX = NULL, hY = NULL, rule = c("Silverman", "Scott"))
}
\arguments{
\item{X, Y}{\code{n}-by-\code{d} and \code{m}-by-\code{d} matrices, representing \code{n} samples from
the true distribution \eqn{P} and \code{m} samples from the approximate distribution
\eqn{Q}, both in \code{d} dimensions. Vector input is treated as a column matrix.}

\item{hX, hY}{Positive scalars or length \code{d} vectors, representing bandwidth
parameters (possibly different in each component) for the density estimates
of \eqn{P} and \eqn{Q}, respectively. If unspecified, a heurestic specified
via the \code{rule} argument is used.}

\item{rule}{A heuristic for computing arguments \code{hX} and/or \code{hY}. The default
\code{"silverman"} is Silverman's rule
\deqn{h_i = \sigma_i\left(\frac{4}{(2+d)n}\right)^{1/(d+4)}.}
As an alternative, Scott's rule \code{"scott"} can be used,
\deqn{h_i = \frac{\sigma_i}{n^{1/(d+4)}}.}}
}
\value{
A scalar, the estimated Kullback-Leibler divergence \eqn{\hat D_{KL}(P||Q)}.
}
\description{
Disclaimer: this function doesn't use binning and/or the fast Fourier transform
and hence, it is extremely slow even for moderate datasets. For this reason,
it is not exported currently.
}
\details{
This estimation method approximates the densities of the unknown distributions
\eqn{P} and \eqn{Q} by kernel density estimates, using a sample size- and
dimension-dependent bandwidth parameter and a Gaussian kernel. It works for
any number of dimensions but is very slow.
}
\examples{
# KL-D between two samples from 1-D Gaussians:
set.seed(0)
X <- rnorm(100)
Y <- rnorm(100, mean = 1, sd = 2)
kld_gaussian(mu1 = 0, sigma1 = 1, mu2 = 1, sigma2 = 2^2)
kld_est_kde1(X, Y)
kld_est_nn(X, Y)
kld_est_brnn(X, Y)

# KL-D between two samples from 2-D Gaussians:
set.seed(0)
X1 <- rnorm(100)
X2 <- rnorm(100)
Y1 <- rnorm(100)
Y2 <- Y1 + rnorm(100)
X <- cbind(X1,X2)
Y <- cbind(Y1,Y2)
kld_gaussian(mu1 = rep(0,2), sigma1 = diag(2),
             mu2 = rep(0,2), sigma2 = matrix(c(1,1,1,2),nrow=2))
kld_est_kde2(X, Y)
kld_est_nn(X, Y)
kld_est_brnn(X, Y)
}
