% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRangedKmerTable.R
\name{buildRangedKmerTable}
\alias{buildRangedKmerTable}
\title{Count kmers from a sequence in given ranges and build a data.table of k-mer
counts.}
\usage{
buildRangedKmerTable(
  dna.seq,
  starts,
  ends,
  k,
  method = "sliding",
  chopping.method = "auto",
  remove.N = TRUE
)
}
\arguments{
\item{dna.seq}{String of sequence.}

\item{starts}{Start positions.}

\item{ends}{End positions.}

\item{k}{Size of kmer.}

\item{method}{Method options: "sliding" or "chopping". Chopping consumes a
lot of memory for extremely long sequence using "substring" method. Using
"Biostrings" for k > 12 is memory consuming. Default is "sliding".}

\item{chopping.method}{Chopping method: "Biostrings" or "substring". Default
is "auto".}

\item{remove.N}{Remove unknown base N? Default is TRUE.}
}
\value{
A \code{data.table} object with column kmer and N.
}
\description{
Count kmers from a sequence in given ranges and build a data.table of k-mer
counts.
}
