% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpodclustr-package.r
\name{assign_clustpp}
\alias{assign_clustpp}
\title{Function for assigning clusters to rows in a matrix}
\usage{
assign_clustpp(X, init_centers, kmpp_flag = TRUE, max_iter = 20)
}
\arguments{
\item{X}{Data matrix containing missing entries whose rows are observations and columns are features}

\item{init_centers}{Centers for initializing k-means}

\item{kmpp_flag}{(Optional) Indicator for whether or not to initialize with k-means++}

\item{max_iter}{(Optional) Maximum number of iterations}
}
\description{
\code{assign_clustpp} Function for assigning clusters to rows in a matrix
}
\examples{
p <- 2
n <- 100
k <- 3
sigma <- 0.25
missing <- 0.05
Data <- makeData(p,n,k,sigma,missing)
X <- Data$Missing
Orig <- Data$Orig

clusts <- assign_clustpp(Orig, k)

}
\author{
Jocelyn T. Chi
}
