% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.es.R
\name{boot.es}
\alias{boot.es}
\title{Boostrapped CI for Effect Size measures}
\usage{
boot.es(y, g, x = 0, nrep = 1000, alpha = 0.05)
}
\arguments{
\item{y}{the raw posttest scores of a continuous outcome variable.}

\item{g}{the categorical variable that denotes the group membership.}

\item{x}{(optional) the raw pretest scores of a continuous outcome variable.}

\item{nrep}{the number of boostrapped samples. (default=1000)}

\item{alpha}{the significance level (default=.05)}
}
\value{
a table of lower and upper limit from bias-corrected and accelerated and expanded percentile boostrapped
confidence interval. The first row is on the geometric mean of the control group
(default group of comparison). After that, zeta estimates are given of the each respective group versus
the control group (default group of comparison). Then, if pretest scores are given, CI on the beta
estimate is given. Lastly, CI on the signal-to-noise ratio, an overall effect size measure, is provided.
        \item{BCa LL}{the lower limit of the Bias-Corrected and accelerated boostrapped Confidence Interval}
        \item{BCa UL}{the upper limit of the Bias-Corrected and accelerated boostrapped Confidence Interval}
        \item{exp LL}{the lower limit of the expanded percentile boostrapped Confidence Interval}
        \item{exp UL}{the upper limit of the expanded percentile boostrapped Confidence Interval}
}
\description{
Compute the bias-corrected and expanded percentile boostrapped confidence intervals
for effect size estimates zetas and the overall signal-to-noise ratio. Additionally,
if pretest scores are provided, boostrapped CI on beta is also given.
}
\examples{
data("schoene")
attach(schoene)
boot.es(post_HRT,group,pre_HRT,1000,.05)
}
\references{
Efron, B. (1987). "Better Bootstrap Confidence Intervals". Journal of the American Statistical Association. Journal of the American Statistical Association, Vol. 82, No. 397. 82 (397): 171–185. doi:10.2307/2289144. JSTOR 2289144.
}
