% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/login.R
\name{module_login}
\alias{module_login}
\title{Login Module for Shiny}
\usage{
module_login(
  input,
  session,
  users = c("123", "321"),
  pwds = c("123", "321"),
  logo = NA,
  logo_height = "100px",
  lang = "es",
  style = list(botton_txt_colour = "#FFFFFF", botton_bgd_colour = "#EBB600"),
  change_text = list(),
  logged = FALSE,
  personal = "MacBookBLB.local"
)
}
\arguments{
\item{input, session}{Shiny's input and session objects.}

\item{users, pwds}{Character Vector. User and password combinations accepted}

\item{logo}{Character. Select image for logo display. Host local
file in your www directory preferably}

\item{logo_height}{Character. Height for rendering the logo.}

\item{lang}{Character. Language. Currently accepted: es, en}

\item{style}{List. Possible values for styling the module such as
\code{botton_txt_colour} and \code{botton_bgd_colour}.}

\item{change_text}{Named list. Change the default texts used.}

\item{logged}{Boolean. You might want to set to TRUE when developing
or testing your app so this module doesn't show up every time.
Check the personal parameter as well}

\item{personal}{Character vector. If you wish to auto-login certain
user(s), set the values from \code{Sys.info()[["nodename"]]}.}
}
\value{
A reactiveValues object
}
\description{
Login Module for Shiny with local User and Password. This must be
added in the server section (no need to add UI)
}
\examples{
if (interactive()) {
  ui <- fluidPage("Hello lareshiny!")
  server <- function(input, output, session) {
    login <- module_login(input, session, personal = "")
    observe({
      if (login$authenticated) message("We are in!")
    })
  }
  shinyApp(ui, server)
}
}
