% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmm.random.R
\name{rsender-ergmTerm}
\alias{rsender-ergmTerm}
\alias{InitErgmTerm.rsender}
\title{Random sender effect}
\usage{
# binary: rsender(var=1, var.df=3)

# valued: rsender(var=1, var.df=3)
}
\arguments{
\item{var}{The scale parameter for the scale-inverse-chi-squared
prior distribution of the sender effect variance. To set
it in the \code{prior} argument to \code{\link{ergmm}}, use
\code{sender.var}.}

\item{var.df}{The degrees of freedom parameter for the
scale-inverse-chi-squared prior distribution of the sender effect
variance. To set it in the \code{prior} argument to
\code{\link{ergmm}}, use \code{sender.var.df}.}
}
\description{
Adds a random sender effect to the model, with normal
prior centered around \eqn{0}{0} and a variance that is
estimated. Can only be used on directed networks.

\strong{Important:} This term works in \CRANpkg{latentnet}'s \code{\link[=ergmm]{ergmm()}} only. Using it in \code{\link[ergm:ergm]{ergm()}} will result in an error.
}
\details{
The following parameters are associated with this term:
\describe{

\item{\code{sender}}{ Numeric vector of values of each
vertex's random sender effect.}

\item{\code{sender.var}}{ Random sender effect's variance.}

}
}
\note{
This term can only be used with directed networks.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "rsender", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{latent}
