% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch_imp.R
\name{patch_imp}
\alias{patch_imp}
\title{Prioritization of patches}
\usage{
patch_imp(landscape, metric, vector_out = FALSE)
}
\arguments{
\item{landscape}{Object of class "lconnect" created by \code{\link{upload_land}}.}

\item{metric}{String indicating the connectivity metric to use in the 
prioritization.}

\item{vector_out}{TRUE/FALSE indicating if the resulting spatial object 
should be recorded to file.}
}
\value{
An object of class "pimp". This object is a list with the
following values:
\item{landscape}{Spatial polygon object of class "sf" (package "sf") with 
cluster identity and importance of each polygon.}
\item{prioritization}{Vector with patch importance in percentage.}
}
\description{
Prioritization of patches according to individual contribution 
to overall connectivity.
}
\details{
Each patch is removed at a time and connectivity 
metrics are recalculated without that specific patch. Patch importance value
indicates the percentage of reduction in the connectivity metric that the 
loss of that patch represents in the landscape. The current version only 
allows the use of IIC or AWF.
}
\examples{
vec_path <- system.file("extdata/vec_projected.shp", package = "lconnect")
landscape <- upload_land(vec_path, bound_path = NULL,
                        habitat = 1, max_dist = 500)
importance <- patch_imp(landscape, metric = "IIC")
plot(importance)
}
\references{
Saura, S., Pascual-Hortal, L. (2007). A new habitat 
availability index to integrate connectivity in landscape conservation planning: 
Comparison with existing indices and application to a case study. Landscape and
Urban Planning, 83(2-3):91-103.
}
\author{
Frederico Mestre

Bruno Silva
}
