% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{log_likelihood_ind}
\alias{log_likelihood_ind}
\title{Log-likelihood computation for a single observation}
\usage{
log_likelihood_ind(tau, mu, b, delta, cens, D)
}
\arguments{
\item{tau}{vector of size n containing the response times}

\item{mu}{matrix of size (n x d1) containing the drift parameters
corresponding to the n response times for each possible d1 decision}

\item{b}{matrix of size (n x d1) containing the boundary parameters
corresponding to the n response times for each possible d1 decision}

\item{delta}{vector of size n containing the offset parameters corresponding
to the n response times}

\item{cens}{vector of size n containing censoring indicators (1 censored, 0
not censored) corresponding to the n response times}

\item{D}{(n x 2) matrix whose first column has the n input stimuli, and whose second column has the n decision categories}
}
\description{
Compute the log-likelihood for the drift-diffusion model, including the
censored data contribution, for a single observation.
}
