% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{leakr_import}
\alias{leakr_import}
\title{Import data from various sources for leakage analysis}
\usage{
leakr_import(
  source,
  format = "auto",
  preprocessing = list(),
  encoding = "UTF-8",
  sheet = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{source}{Path to data file, data.frame, or other supported object.}

\item{format}{Data format: "auto", "csv", "excel", "rds", "json", "parquet", "tsv".
If "auto", the format will be detected from the file extension.}

\item{preprocessing}{List of preprocessing options to apply after import.}

\item{encoding}{Character encoding for reading files. Default is "UTF-8".}

\item{sheet}{Sheet name or index to read (for Excel files). Default is NULL.}

\item{verbose}{Logical indicating whether to print progress messages. Default TRUE.}

\item{...}{Additional arguments passed to specific import functions.}
}
\value{
Standardised data.frame suitable for leakage analysis

A standardized data.frame suitable for leakage analysis.
}
\description{
Flexible data import function supporting multiple formats with automatic format detection and preprocessing for leakage analysis.
}
