% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anypfcdfdiscrete.R
\name{apf}
\alias{apf}
\title{Plot of probability function of any discrete variable}
\usage{
apf(x, p, main = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{x}{numeric vector of values of \eqn{X}. See \strong{Details}.}

\item{p}{numeric vector of \eqn{p_X(x)}. See \strong{Details}.}

\item{main}{main title for the plot.}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}
}
\value{
The output is plot of distribution function. See \emph{Example 1}.
}
\description{
Help in building the plot of the probability function of any discrete variable
}
\details{
Consider the \eqn{X} distribution:\tabular{rccccc}{
   \eqn{p_X(x)}: \tab 0.23 \tab 0.27 \tab 0.30 \tab 0.12 \tab 0.08 \cr
   \eqn{x}: \tab 1 \tab 2 \tab 3 \tab 4 \tab 5 \cr
}


where \eqn{p_X(x)} and \eqn{x} are probability function and values of \eqn{X}. See \emph{Example 1}.
}
\examples{
# Example 1
x <- 1:5
p <- c(0.23, 0.27,0.30, 0.12, 0.08)
apf(x, p)
}
