% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_of_position.R
\name{mfreq}
\alias{mfreq}
\title{Mode value}
\usage{
mfreq(x, na.rm = FALSE, rounding = 2, grouped = TRUE, details = FALSE)
}
\arguments{
\item{x}{R object (list) of class leem. Use \code{new_leem()} function.}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}

\item{rounding}{Numerical object. Rounds the values in its first argument to the specified number of decimal places (default \code{2}).}

\item{grouped}{Logical object. Determines whether the measure of position result will be based on grouped data or not (default \code{TRUE}).}

\item{details}{Logical object. Details of data (default \code{FALSE}).}
}
\description{
Compute the sample mode.
}
\examples{
library(leem)
# set.seed(10)
x <- rnorm(36, 100, 50)
set.seed(10)
y <- rbinom(36, 10, 0.8)
w <- rep(letters[1:4], 1:4)
(tab1 <- y |> new_leem(variable = "discrete") |> tabfreq())
(tab2 <- x |> new_leem(variable = "continuous") |> tabfreq())
(tab3 <- w |> new_leem(variable = "discrete") |> tabfreq())
y |> new_leem(variable = "discrete") |> tabfreq() |> mfreq()
x |> new_leem(variable = "continuous") |> tabfreq() |> mfreq()
w |> new_leem(variable = "discrete") |> tabfreq() |> mfreq()

}
