% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularizeSEMWithCustomPenalty.R
\name{.regularizeSEMWithCustomPenaltyRsolnp}
\alias{.regularizeSEMWithCustomPenaltyRsolnp}
\title{.regularizeSEMWithCustomPenaltyRsolnp}
\usage{
.regularizeSEMWithCustomPenaltyRsolnp(
  lavaanModel,
  individualPenaltyFunction,
  tuningParameters,
  penaltyFunctionArguments,
  startingValues = "est",
  carryOverParameters = TRUE,
  control = list(trace = 0)
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{individualPenaltyFunction}{penalty function which takes the current parameter values as first argument, the tuning parameters as second, and the penaltyFunctionArguments as third argument and
returns a single value - the value of the penalty function for a single person. If the true penalty function is non-differentiable (e.g., lasso) a smooth
approximation of this function should be provided.}

\item{tuningParameters}{data.frame with tuning parameter values. Important: The function will iterate over the rows of these tuning parameters and pass them to your penalty function}

\item{penaltyFunctionArguments}{arguments passed to individualPenaltyFunction, individualPenaltyFunctionGradient, and individualPenaltyFunctionHessian}

\item{startingValues}{option to provide initial starting values. Only used for the first lambda. Three options are supported. Setting to "est" will use the estimates
from the lavaan model object. Setting to "start" will use the starting values of the lavaan model. Finally, a labeled vector with parameter
values can be passed to the function which will then be used as starting values.}

\item{carryOverParameters}{should parameters from the previous iteration be used as starting values of
the next iteration?}

\item{control}{option to set parameters of the optimizer; see ?Rsolnp::solnp}
}
\value{
Model of class regularizedSEMWithCustomPenalty
}
\description{
Optimize a SEM with custom penalty function using the Rsolnp optimizer (see ?Rsolnp::solnp). This optimizer is the default in regsem (see ?regsem::cv_regsem).
}
\keyword{internal}
