% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dt_na_breakdown}
\alias{dt_na_breakdown}
\title{Get a breakdown of the NA-status of a column in a data.table}
\usage{
dt_na_breakdown(DT, acolumn, big.mark = FALSE)
}
\arguments{
\item{DT}{The data.table object to operate on}

\item{acolumn}{a quoted column name}

\item{big.mark}{If \code{FALSE} (default) the "count" column is left
as an integer. If not \code{FALSE}, it must be a
character to separate every three digits of the count.
This turns the count column into a string.}
}
\value{
Returns a data.table with three columns:
        the not-NA status of the column specified, a count column, and a
        percent column (out of 100) to two decimal places
}
\description{
This function takes a (quoted) column to group by, and tabulates
the count of how many of those values are not-NA and NA, and adds
the percent of occurrences. A \code{TRUE} in the first output
column means the data is _not_ missing; \code{FALSE} corresponds
to missing.
}
\details{
The final row is a total count

The quoted group-by variable must be a character or factor
}
\examples{

iris_dt <- as.data.table(iris)
iris_dt[sample(1:.N, 10), Species:=NA_character_]
dt_na_breakdown(iris_dt, "Species")

}
