% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{lx_effect_breathe}
\alias{lx_effect_breathe}
\title{"Breathe" effect}
\usage{
lx_effect_breathe(
  color,
  from_color = NULL,
  period = 1,
  cycles = 1,
  persist = FALSE,
  power_on = TRUE,
  peak = 0.5,
  selector = "all",
  token = lx_get_token()
)
}
\arguments{
\item{color}{color The color to use for the breathe effect. use lx_color() as input}

\item{from_color}{The color to start the effect from. If this parameter is omitted then the color the bulb is currently set to is used instead.}

\item{period}{The time in seconds for one cycle of the effect.}

\item{cycles}{The number of times to repeat the effect.}

\item{persist}{boolean; If FALSE set the light back to its previous value when effect ends, if true leave the last effect color.}

\item{power_on}{If FALSE, does not turn light on if it is off}

\item{peak}{Defines where in a period the target color is at its maximum. Minimum 0.0, maximum 1.0.}

\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
an 'httr' response object (see \code{\link[httr]{response}})
}
\description{
"Breathe" effect
}
\examples{
\dontrun{
lx_effect_breathe(color = "red",from_color = "blue",period = 3,cycles = 5,power_on = TRUE)
}
}
