% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup.R
\name{lineupBuilder}
\alias{lineupBuilder}
\title{lineup builder pattern function}
\usage{
lineupBuilder(data, options = c(.lineupDefaultOptions), ranking = NULL, ...)
}
\arguments{
\item{data}{data frame like object i.e. also crosstalk shared data frame}

\item{options}{LineUp options}

\item{ranking}{ranking definition created using \code{\link{lineupRanking}}}

\item{...}{additional ranking definitions like 'ranking1=...' due to restrictions in converting parameters}
}
\value{
lineup builder object
}
\description{
lineup builder pattern function
}
\section{LineUp options}{

\describe{
\item{filterGlobally}{whether filter within one ranking applies to all rankings (default: TRUE)}
\item{singleSelection}{restrict to single item selection (default: FALSE}
\item{noCriteriaLimits}{allow more than one sort and grouping criteria (default: FALSE)}
\item{animated}{use animated transitions (default: TRUE)}
\item{sidePanel}{show side panel (TRUE, FALSE, 'collapsed') (default: 'collapsed')}
\item{hierarchyIndicator}{show sorting and grouping hierarchy indicator (TRUE, FALSE) (default: TRUE)}
\item{labelRotation}{how many degrees should a label be rotated in case of narrow columns (default: 0)}
\item{summaryHeader}{show summary histograms in the header (default: TRUE)}
\item{overviewMode}{show overview mode in Taggle by default (default: FALSE)}
\item{expandLineOnHover}{expand to full row height on mouse over (default: FALSE)}
\item{defaultSlopeGraphMode}{default slope graph mode: item,band (default: 'item')}
\item{ignoreUnsupportedBrowser}{ignore unsupported browser detection at own risk (default: FALSE)}
\item{rowHeight}{height of a row in pixel (default: 18)}
\item{rowPadding}{padding between two rows in pixel  (default: 2)}
\item{groupHeight}{height of an aggregated group in pixel (default: 40)}
\item{groupPadding}{padding between two groups in pixel (default: 5)}
}
}

\examples{
\dontrun{
lineupBuilder(iris) |> buildLineUp()
}

}
