% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.linktree}
\alias{plot.linktree}
\title{Plot linktree objects}
\usage{
\method{plot}{linktree}(x, ...)
}
\arguments{
\item{x}{An object of class \code{linktree} (with subclasses \code{gamma}, \code{delta}, or \code{pi}).}

\item{...}{Additional arguments passed to the base \code{\link[graphics]{plot}} function.}
}
\value{
No return value, called for side effects (produces a plot).
}
\description{
Plots error bars for objects of class \code{linktree} (with subclasses \code{gamma}, \code{delta}, or \code{pi}).
The method displays point estimates with confidence intervals for each group.
A horizontal dotted line is added at the neutral value: y = 1 for subclass \code{gamma} and y = 0 for subclass \code{delta}.
}
\examples{
from <- c("A", "A", NA, "C", "C", "C")
to <- c("A", "B", "B", "C", "C", "C")
f <- c(A = 0.3, B = 0.2, C = 0.5)
plot(get_delta(from, to, f))
plot(get_gamma(from, to, f))

}
