#' Summary of the listcompr Package
#' 
#' The listcompr package offers some syntactic shortcuts to create lists, vectors and data frames containing values within a given range with given conditions.
#' It is a light-weight package written in base R without any compiled code or dependencies to other packages.
#' 
#' @section Functions:
#' 
#' \itemize{
#' \item The main functionality of listcompr: generate lists, vectors, and data frames: \code{\link{gen.list}}
#' \item Generate named lists, vectors, and data frames: \code{\link{gen.named.list}}
#' \item Generate expressions containing lists and vectors: \code{\link{gen.list.expr}}
#' \item Generate conditions to be used in other functions of listcompr: \code{\link{gen.logical.and}}
#' }
#' 
#' @section Vignettes:
#' 
#' To learn the basics of listcompr, start with the vignette:
#' 
#' \code{vignette("introduction", package = "listcompr")}
#' 
#' @section Contact:
#' 
#' To submit bugs, feature requests or other comments, feel free to write a mail to me.
#' 
#' @author Patrick Roocks, \email{mail@@p-roocks.de}
#'
#' @docType package
#' @name listcompr
NULL
