% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_join_df.R
\name{list_join_df}
\alias{list_join_df}
\title{Join a list of data frames on a common index.}
\usage{
list_join_df(in_list, join_type = "inner", by = NULL, skip_non_df = FALSE)
}
\arguments{
\item{in_list}{A list of data frames.}

\item{join_type}{A string specifying the join strategy to use. Must be
one of "inner", "left", "right" or "full".}

\item{by}{Optional vector of strings specifying columns to merge by.}

\item{skip_non_df}{Should elements that are not data.frames be skipped?}
}
\value{
A data frame.
}
\description{
Join a list of data frames on a common index.
}
\details{
Using `join_type` you can specify how to join the data. The default
`inner` will keep only observations present in all data frames. `left` will
keep all observations from the first data frame in the list and merge the
matching items from the rest, while `right` will keep all observations from
the last data frame in the list. Using `full` will keep all observations.

If `by` is not supplied, then data frames will be merged on columns with
names they all have. Otherwise merging is done on the specified columns.

Using `skip_non_df` you can specify to omit elements from the input list
that are not data frames. If FALSE (the default) an error will be thrown
if elements are present that are not data frames.
}
\examples{
dfl <- list(data.frame(idx = sample(100, 30), x = rnorm(30)),
            data.frame(idx = sample(100, 30), y = rnorm(30)),
            data.frame(idx = sample(100, 30), z = rnorm(30)))
list_join_df(dfl)
}
