% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_landmarks.R
\name{select_landmarks}
\alias{select_landmarks}
\title{Select landmarks from dataset}
\usage{
select_landmarks(x, distance_method = c("euclidean", "pearson",
  "spearman", "cosine", "manhattan"), landmark_method = c("sample"),
  num_landmarks = 500)
}
\arguments{
\item{x}{A matrix, optionally sparse.}

\item{distance_method}{The distance metric to use. Options are "euclidean" (default), "pearson", "spearman", "cosine", "manhattan".}

\item{landmark_method}{The landmark selection method to use. Options are "sample" (default).}

\item{num_landmarks}{The number of landmarks to use,}
}
\value{
The distance matrix between the landmarks and all samples. In addition, an attribute \code{"landmark_ix"}
denotes the indices of landmarks that were sampled.
}
\description{
In addition, the distances between the landmarks and all samples are calculated.
}
\examples{
library(Matrix)
x <- Matrix::rsparsematrix(1000, 1000, .01)
select_landmarks(x)
}
