% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_plot.R
\name{scatter_plot}
\alias{scatter_plot}
\title{Locus scatter plot}
\usage{
scatter_plot(
  loc,
  index_snp = loc$index_snp,
  pcutoff = 5e-08,
  scheme = c("grey", "dodgerblue", "red"),
  cex = 1,
  cex.axis = 0.9,
  cex.lab = 1,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  ylim2 = c(0, 100),
  yzero = (loc$yvar == "logP"),
  xticks = TRUE,
  border = FALSE,
  showLD = TRUE,
  LD_scheme = c("grey", "royalblue", "cyan2", "green3", "orange", "red", "purple"),
  recomb_col = "blue",
  recomb_offset = 0,
  legend_pos = "topleft",
  labels = NULL,
  label_x = 4,
  label_y = 4,
  eqtl_gene = NULL,
  beta = NULL,
  add = FALSE,
  align = TRUE,
  ...
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \link{locus}.}

\item{index_snp}{Specifies index SNP or a vector of SNPs to be shown in a
different colour and symbol. Defaults to the SNP with the lowest p-value.
Set to \code{NULL} to not show this.}

\item{pcutoff}{Cut-off for p value significance. Defaults to p = 5e-08. Set
to \code{NULL} to disable.}

\item{scheme}{Vector of 3 colours if LD is not shown: 1st = normal points,
2nd = colour for significant points, 3rd = index SNP(s).}

\item{cex}{Specifies size for points.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{cex.lab}{Specifies font size for axis titles.}

\item{xlab}{x axis title.}

\item{ylab}{y axis title.}

\item{ylim}{y axis limits (y1, y2).}

\item{ylim2}{Secondary y axis limits for recombination line, if present.}

\item{yzero}{Logical whether to force y axis limit to include y=0.}

\item{xticks}{Logical whether x axis numbers and axis title are plotted.}

\item{border}{Logical whether a bounding box is plotted around upper and
lower plots.}

\item{showLD}{Logical whether to show LD with colours}

\item{LD_scheme}{Vector of colours for plotting LD. The first colour is for
SNPs which lack LD information. The next 5 colours are for r2 or D' LD
results ranging from 0 to 1 in intervals of 0.2. The final colour is for
the index SNP.}

\item{recomb_col}{Colour for recombination rate line if recombination rate
data is present. Set to \code{NA} to hide the line. See \code{\link[=link_recomb]{link_recomb()}} to add
recombination rate data.}

\item{recomb_offset}{Offset from 0-1 which shifts the scatter plot up and
recombination line plot down. Recommended value 0.1.}

\item{legend_pos}{Position of legend. See \code{\link[=legend]{legend()}}. Set to \code{NULL} to hide
legend.}

\item{labels}{Character vector of SNP or genomic feature IDs to label. The
value "index" selects the highest point or index SNP as defined when
\code{\link[=locus]{locus()}} is called. Set to \code{NULL} to remove all labels.}

\item{label_x}{Value or vector for position of label as percentage of x axis
scale.}

\item{label_y}{Value or vector for position of label as percentage of y axis
scale.}

\item{eqtl_gene}{Column name in \code{loc$data} for colouring eQTL genes.}

\item{beta}{Optional column name for beta coefficient to display upward
triangles for positive beta and downward triangles for negative beta
(significant SNPs only).}

\item{add}{Logical whether to add points to an existing plot or generate a
new plot.}

\item{align}{Logical whether to set \code{\link[=par]{par()}} to align the plot.}

\item{...}{Other arguments passed to \code{\link[=plot]{plot()}} to control the scatter plot
e.g. \code{main}, \code{ylim} etc.}
}
\value{
No return value. Produces a scatter plot using base graphics.
}
\description{
Produces a base graphics scatter plot from a 'locus' class object. This
function is called by \code{\link[=locus_plot]{locus_plot()}} to generate the scatter plot portion.
Can be used manually with \code{\link[=set_layers]{set_layers()}}.
}
\details{
Advanced users familiar with base graphics can customise every single point
on the scatter plot, by adding columns named \code{bg}, \code{col}, \code{pch} or \code{cex}
directly to the dataframe stored in \verb{$data} element of the 'locus' object.
Setting these will overrule any default settings. These columns refer to
their respective base graphics arguments, see \code{\link[graphics:points]{graphics::points()}}.
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=set_layers]{set_layers()}}
}
