% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate_params}
\alias{estimate_params}
\title{Estimate the parameters for a given data set and model}
\usage{
estimate_params(
  data,
  init_params = c(beta_A = 0.25, beta_B = 0.25, gamma_A = 0.5, gamma_B = 0.5, tau_1 = 0,
    tau_2 = 0),
  n_boot = 100,
  GIA_fn = base_GIA,
  S_fn = calc_S_base,
  fn_list = NULL,
  alpha = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{data}{data frame with the following columns
\itemize{
\item{dose_A}{dose A mg/mL}
\item{dose_B}{dose B mg/mL}
\item{GIA}{GIA}
}}

\item{init_params}{named vector of parameters, that correspond to those used in 'GIA_fn'.  These will be used as the initial guesses.  A default is provided.}

\item{n_boot}{number of boot straps to use to estimate confidence intervals of the parameters, GIA estimates, and values of S.  The default is 100.  If n_boot = 0, then no bootstraps will be run and only the point estimates will be returned.}

\item{GIA_fn}{function to calculate the GIA from dose_A and dose_B combinations and given set of parameters.  Default is base_GIA}

\item{S_fn}{Function to calculate S. Default is calc_S_base}

\item{fn_list}{additional arguments to pass to GIA_fn}

\item{alpha}{alpha level used to produce CIs.  The bootstrap will use a two-tailed method.  The default is .05 to produce a 95\% CI}

\item{verbose}{logical indicating whether we should print where we are in the process.  Default is FALSE.}
}
\value{
a list with the following elements
\itemize{
\item{params_est}{a data frame of dimension # of params x 4 where each row in the data frame is a parameter and where the columns are the mean, lower, alpha/2 quantile,  and upper,100 - alpha/2 quantile}
\item{S_est}{ a data frame of one row  x 4 where we provide the mean, lower, and upper estimates}
\item{GIA_est}{the original data with additional columns of the mean, lower, and upper estimates for each dose combination}
\item{SSE}{Sum of Square Error for the model under the best (mean) parameters}
}
}
\description{
Estimate the parameters for a given data set and model
}
\examples{

df <- loewesadditivity::cyrpa_ripr
df$dose_A <- df$CyRPA
df$dose_B <- df$RIPR
data <- fortify_gia_data(df)
model_params <- c("beta_A" = .5, "beta_B" = .5,
                 "gamma_A" = .5, "gamma_B" = .5,
                 "tau_1" = 0, "tau_2" = 0)
n_boot <- 10
GIA_fn <- base_GIA
S_fn <- calc_S_base
fn_list <- NULL
alpha <- .05
verbose <- FALSE
out <- estimate_params(data = data,
init_params = model_params,
n_boot = n_boot,
GIA_fn = GIA_fn,
S_fn = S_fn,
fn_list = fn_list,
alpha = alpha,
verbose = verbose)
names(out)
}
