% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bittermelon.R
\name{convert_bm_font_to_lofi}
\alias{convert_bm_font_to_lofi}
\title{Convert a 'bittermelon' 'bm_font' to a lofi font}
\usage{
convert_bm_font_to_lofi(font, font_name = "Unknown")
}
\arguments{
\item{font}{font object of class \code{bm_font}}

\item{font_name}{Name of font}
}
\value{
lofi font object
}
\description{
Convert a 'bittermelon' 'bm_font' to a lofi font
}
\examples{
\dontshow{if (interactive() && requireNamespace('bittermelon', quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
filename <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
bmfont <- bittermelon::read_hex(filename)
lofi <- convert_bm_font_to_lofi(bmfont)
lofi
\dontshow{\}) # examplesIf}
}
