% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticSVD.R
\name{predict.lsvd}
\alias{predict.lsvd}
\title{Predict Logistic SVD left singular values or reconstruction on new data}
\usage{
\method{predict}{lsvd}(object, newdata, quiet = TRUE, max_iters = 1000,
  conv_criteria = 1e-05, random_start = FALSE, start_A, type = c("PCs",
  "link", "response"), ...)
}
\arguments{
\item{object}{logistic SVD object}

\item{newdata}{matrix with all binary entries. If missing, will use the 
data that \code{object} was fit on}

\item{quiet}{logical; whether the calculation should give feedback}

\item{max_iters}{number of maximum iterations}

\item{conv_criteria}{convergence criteria. The difference between average deviance
in successive iterations}

\item{random_start}{logical; whether to randomly inititalize the parameters. If \code{FALSE},
algorithm implicitly starts \code{A} with 0 matrix}

\item{start_A}{starting value for the left singular vectors}

\item{type}{the type of fitting required. \code{type = "PCs"} gives the left singular vectors, 
\code{type = "link"} gives matrix on the logit scale and \code{type = "response"} 
gives matrix on the probability scale}

\item{...}{Additional arguments}
}
\description{
Predict Logistic SVD left singular values or reconstruction on new data
}
\details{
Minimizes binomial deviance for new data by finding the optimal left singular vector
matrix (\code{A}), given \code{B} and \code{mu}. Assumes the columns of the right 
singular vector matrix (\code{B}) are orthonormal.
}
\examples{
# construct a low rank matrices in the logit scale
rows = 100
cols = 10
set.seed(1)
loadings = rnorm(cols)
mat_logit = outer(rnorm(rows), loadings)
mat_logit_new = outer(rnorm(rows), loadings)

# convert to a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0
mat_new = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit_new)) * 1.0

# run logistic PCA on it
lsvd = logisticSVD(mat, k = 1, main_effects = FALSE, partial_decomp = FALSE)

A_new = predict(lsvd, mat_new)
}

