% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{linking}
\alias{linking}
\title{Modify the \code{linking} component}
\usage{
linking(
  linkingGroup = NULL,
  linkingKey = NULL,
  linkedStates = NULL,
  sync = NULL
)
}
\arguments{
\item{linkingGroup}{The string identifying the group of linked plots that the current plot will join.  Default is none.}

\item{linkingKey}{The length \code{n} character vector of unique keys.  Default will be \code{"0", "1", ..., "n-1"}
where \code{n} is the number of elements (e.g., points) displayed.}

\item{linkedStates}{The character vector of display states to be linked.
These can be "color", "selected", "active", "size" and "glyph" for an `l_plot` object and
"color", "selected", "active" for an `l_hist` object.  (These roughly correspond to aesthetics in a `ggplot`.)}

\item{sync}{Either \code{"pull"} (the default) or \code{"push"} to indicate whether the values of the linked states of the plot
are to be pulled from those of the other plots in the linking group, or the values are to be pushed to all other plots
in the linking group. This matters only when joining an existing group of plots and the default value is typically
the right thing to do.}
}
\value{
a \code{ggproto} object
}
\description{
A group-key-state linking model is used to link plots in \code{loon}.  This allows changes in one plot
to propogate to all plots in the same \code{linkingGroup} and enables interactive features like brushing.
Elements to be matched between plots are identified by \code{linkingKey}; within each plot, the key for each
element (e.g., case, observation) is unique.  The \code{linkedStates} identify which display states (e.g., "color")
should change in concert with other plots in the \code{linkingGroup}.
}
\examples{
if(interactive() && requireNamespace("dplyr")) {
  h <- l_hist(mtcars$hp,
              linkingKey = rownames(mtcars),
              linkingGroup = "mtcars")

  mtcars \%>\%
    mutate(carName = rownames(mtcars)) \%>\%
    l_ggplot(mapping = aes(x = wt, y = hp, color = factor(cyl))) +
       geom_point(size = 4) +
       # push the states of scatter plot to the histogram
       linking(linkingGroup = "mtcars",
               linkingKey = ~carName,
               sync = "push")
}
}
\seealso{
\code{\link{active}}, \code{\link{selection}}, \code{\link{zoom}},
\code{\link{hover}}, \code{\link{interactivity}},
\code{\link[loon]{l_getLinkedStates}}, \code{\link[loon]{l_setLinkedStates}}, \code{\link[loon]{l_configure}}
}
