% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orientation_helpers.R
\name{infer_orientation_signs}
\alias{infer_orientation_signs}
\title{Infer orientation signs for each observable indicator}
\usage{
infer_orientation_signs(Y, observables, method = c("Y", "PC1"))
}
\arguments{
\item{Y}{Numeric outcome vector. Only used when \code{method = "Y"}.}

\item{observables}{A matrix or data frame of binary observable indicators.}

\item{method}{Character string specifying how to orient the indicators.
\describe{
  \item{\code{"Y"}}{orient each indicator so that its correlation with
    \code{Y} is positive.}
  \item{\code{"PC1"}}{orient each indicator so that its correlation with
    the first principal component of \code{observables} is positive.}
}
Default is \code{"Y"}.}
}
\value{
A numeric vector of length \code{ncol(observables)} containing
  \code{1} or \code{-1}.
}
\description{
This helper analyzes observable indicators and returns a numeric vector
of \code{1} or \code{-1} for use with the \code{orientation_signs}
argument in \code{lpmec}. Each sign is chosen so that the correlation
between the oriented indicator and either the outcome \code{Y} or the
first principal component of the indicators is positive.
}
\examples{
set.seed(1)
Y <- rnorm(10)
obs <- data.frame(matrix(sample(c(0,1), 20, replace = TRUE), ncol = 2))
infer_orientation_signs(Y, obs)
}
