% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqr.R
\name{lqr}
\alias{lqr}
\title{Linear Quantile Regression}
\usage{
lqr(formula, data, qtl = 0.5, se = TRUE, R = 100, verbose = TRUE,
  seed = NULL, parallel = FALSE, ncores = 2, ...)
}
\arguments{
\item{formula}{an object of class \code{formula}: a symbolic description of the model to be fitted}

\item{data}{a data frame containing the variables named in \code{formula}}

\item{qtl}{quantile to be estimated}

\item{se}{standard error computation}

\item{R}{number of bootstrap samples for computing standard errors}

\item{verbose}{if set to FALSE, no printed output is given during the function execution}

\item{seed}{an integer value for random numbers generation, used for bootstrap standard errors}

\item{parallel}{if set to TRUE, a parallelized code is use for standard error computation (if se=TRUE)}

\item{ncores}{number of cores used for computing bootstrap standard errors (if required)}

\item{...}{not used}
}
\value{
Return an object of \code{class} \code{lqr}. This is a list containing the following elements:
\item{betaf}{a vector containing fixed regression coefficients}
\item{scale}{the scale parameter}
\item{sigma.e}{the standard deviation of error terms}
\item{lk}{the log-likelihood}
\item{npar}{the total number of model parameters}
\item{AIC}{the AIC value}
\item{BIC}{the BIC value}
\item{qtl}{the estimated quantile}
\item{nobs}{the total number of observations}
\item{se.betaf}{the standard errors for the regression coefficients}
\item{se.scale}{the standard error for the scale parameter}
\item{model}{the estimated model}
\item{mmf}{the model matrix associated to the regression coefficients}
\item{y}{the model response}
\item{call}{the matched call}
\item{formula}{the model formula}
}
\description{
Estimate a linear quantile regression model for independent data (no random coefficients).
}
\details{
The function computes ML estimates for the parameters of a linear quantile regression model for independent observations.
Estimates are derived by maximizing the (log-)likelihood of a Laplace regression, where the location parameter is modeled as a function
of fixed coefficients only.

If \code{se=TRUE}, standard errors based on a bootstrap procedure are computed.
}
\examples{
out0 = lqr(formula=meas~trt+time+trt:time,data=pain,se=TRUE,R=10)
}
\references{
{
  \insertRef{ref:KoeBas}{lqmix}
}
}
