% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_correct_free.R
\name{prop_correct_free}
\alias{prop_correct_free}
\title{Proportion Correct Free Recall}
\usage{
prop_correct_free(
  data,
  responses,
  key,
  id,
  cutoff = 0,
  flag = FALSE,
  group.by = NULL
)
}
\arguments{
\item{data}{a dataframe of the variables you would like to return.
Other variables will be included in the scored output and
in the participant output if they are a one to one match with
the participant id.}

\item{responses}{a column name in the dataframe that contains
the participant answers for each item in quotes (i.e., "column")}

\item{key}{a vector containing the scoring key or data column name.
This column does not have to be included in the original dataframe.}

\item{id}{a column name containing participant ID numbers from
the original dataframe}

\item{cutoff}{a numeric value that determines the criteria for
scoring (i.e., 0 = strictest, 5 = is most lenient). The scoring
criteria uses a Levenshtein distance measure to match participant
responses to the answer key.}

\item{flag}{a logical argument if you want to flag participant scores
that are outliers using z-scores away from the mean score for group}

\item{group.by}{an optional argument that can be used to group the
output by condition columns. These columns should be in the original
dataframe and concatenated c() if there are multiple columns}
}
\value{
\item{DF_Scored}{The dataframe of the original response, answer,
scoring, and any other or grouping variables. This dataframe can
be used to determine if the cutoff score and scoring matched your
answer key as intended. Distance measures are not perfect! Issues
and suggestions for improvement are welcome.}
\item{DF_Participant}{A dataframe of the proportion correct by
participant, which also includes optional z-scoring, grouping, and
other variables.}
\item{DF_Group}{A dataframe of the summary scores by any optional
grouping variables, along with overall total proportion correct
scoring.}
}
\description{
This function computes the proportion of correct responses
per participant. Proportions can either be separated by
condition or collapsed across conditions.
}
\details{
Note: other columns included in the dataframe will be found
in the final scored dataset. If these other columns are
between subjects data, they will also be included in the
participant dataset (i.e., there's a one to one match of
participant ID and column information).
}
\examples{

data(wide_data)
data(answer_key_free)

DF_long <- arrange_data(data = wide_data,
 responses = "Response",
 sep = ",",
 id = "Sub.ID")

scored_output <- prop_correct_free(data = DF_long,
 responses = "response",
 key = answer_key_free$Answer_Key,
 id = "Sub.ID",
 cutoff = 1,
 flag = TRUE,
 group.by = "Disease.Condition")

head(scored_output$DF_Scored)

head(scored_output$DF_Participant)

head(scored_output$DF_Group)

}
\keyword{correct}
\keyword{free}
\keyword{proportion}
\keyword{recall}
\keyword{scoring}
