% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{BOINTable}
\alias{BOINTable}
\title{BOIN Decision Table for Dose-Finding Trials}
\usage{
BOINTable(
  nMax = NA_integer_,
  pT = 0.3,
  phi1 = 0.6 * pT,
  phi2 = 1.4 * pT,
  a = 1,
  b = 1,
  pExcessTox = 0.95
)
}
\arguments{
\item{nMax}{The maximum number of subjects allowed in a dose cohort.}

\item{pT}{The target toxicity probability. Defaults to 0.3.}

\item{phi1}{The lower equivalence limit for the target toxicity
probability.}

\item{phi2}{The upper equivalence limit for the target toxicity
probability.}

\item{a}{The prior toxicity shape parameter for the Beta prior.}

\item{b}{The prior non-toxicity shape parameter for the Beta prior.}

\item{pExcessTox}{The threshold for excessive toxicity.
If the posterior probability that the true toxicity rate exceeds
\code{pT} is greater than \code{pExcessTox}, the current and
all higher doses will be excluded from further use to protect
future participants. Defaults to 0.95.}
}
\value{
An S3 class \code{BOINTable} object with the following
components:
\itemize{
\item \code{settings}: The input settings data frame with the following
variables:
\itemize{
\item \code{nMax}: The maximum number of subjects in a dose cohort.
\item \code{pT}: The target toxicity probability.
\item \code{phi1}: The lower equivalence limit for target toxicity
probability.
\item \code{phi2}: The upper equivalence limit for target toxicity
probability.
\item \code{lambda1}: The lower decision boundary for observed toxicity
probability.
\item \code{lambda2}: The upper decision boundary for observed toxicity
probability.
\item \code{a}: The prior toxicity parameter for the beta prior.
\item \code{b}: The prior non-toxicity parameter for the beta prior.
\item \code{pExcessTox}: The threshold for excessive toxicity.
}
\item \code{decisionDataFrame}: A data frame listing dose-finding decisions
for each combination of sample size (\code{n}) and number of observed
toxicities (\code{y}):
\itemize{
\item \code{n}: Cohort size.
\item \code{y}: Number of observed toxicities.
\item \code{decision}: Recommended action: escalate, de-escalate,
or stay at the current dose.
}
\item \code{decisionMatrix}: A matrix version of the decision table
showing the recommended action based on the number of toxicities
for each possible cohort size.
}
}
\description{
Generates the decision table for the Bayesian Optimal
Interval (BOIN) design, a widely used approach for dose-escalation
trials that guides dose-finding decisions based on observed
toxicity rates.
}
\examples{

BOINTable(nMax = 18, pT = 0.3, phi = 0.6*0.3, phi2 = 1.4*0.3)

}
\references{
Liu, S., & Yuan, Y. (2015).
Bayesian optimal interval designs for phase I clinical trials.
Journal of the Royal Statistical Society:
Series C (Applied Statistics), 64(3), 507-523.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
