% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{Extract Key Cognitive Measures from Dataset}
\usage{
extract(data)
}
\arguments{
\item{data}{A dataframe containing the full dataset from which specific variables will be selected.}
}
\value{
A dataframe with the following variables:
\itemize{
\item \code{HHID}: Household ID.
\item \code{PN}: Person number (individual identifier).
\item Immediate and delayed word recall variables (columns starting with \code{"SD182M"} and \code{"SD183M"}).
\item Serial subtraction variables (\code{SD142} to \code{SD146}).
\item Backwards counting variables (\code{SD124}, \code{SD129}).
}
}
\description{
This function extracts specific cognitive measures from a dataset, including immediate
and delayed word recall, serial subtraction, and backwards counting, along with household
and person identifiers.
}
\details{
The function selects key cognitive test results and identifiers from the dataset.
It uses \code{dplyr::select()} to retrieve:
\itemize{
\item Immediate and delayed word recall variables (those starting with "SD182M" and "SD183M").
\item Serial subtraction results (\code{SD142} to \code{SD146}).
\item Backwards counting variables (\code{SD124}, \code{SD129}).
}
}
\examples{
# Assuming `cog_data` is a dataframe with the relevant columns
extract(cog_data)

}
