% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounding_circle.R
\name{bounding_circle}
\alias{bounding_circle}
\alias{st_minimum_bounding_circle}
\alias{st_minimum_bounding_radius}
\title{Generate the minimum bounding circle}
\usage{
st_minimum_bounding_circle(x, nQuadSegs = 30)

st_minimum_bounding_radius(x)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfc} or \code{sf}}

\item{nQuadSegs}{number of segments per quadrant (passed to \code{st_buffer})}
}
\value{
Object of the same class as \code{x}
}
\description{
Generate the minimum bounding circle
}
\details{
\code{st_minimum_bounding_circle} uses the \code{lwgeom_calculate_mbc} method also used by the PostGIS command \code{ST_MinimumBoundingCircle}. \code{st_minimum_bounding_radius} also uses the \code{lwgeom_calculate_mbc} method, but returns the centers (as a geometry) and the respective radii (as a column).
}
\examples{
library(sf)

x = st_multipoint(matrix(c(0,1,0,1),2,2))
y = st_multipoint(matrix(c(0,0,1,0,1,1),3,2))

mbcx = st_minimum_bounding_circle(x)
mbcy = st_minimum_bounding_circle(y)

if (.Platform$OS.type != "windows") {
  plot(mbcx, axes=TRUE); plot(x, add=TRUE)
  plot(mbcy, axes=TRUE); plot(y, add=TRUE)
}

nc = st_read(system.file("gpkg/nc.gpkg", package="sf"))
state = st_union(st_geometry(nc))

if (.Platform$OS.type != "windows") {
  plot(st_minimum_bounding_circle(state), asp=1)
  plot(state, add=TRUE)
}

}
