% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maicMD.R
\name{maicMD}
\alias{maicMD}
\title{Checks if AD is within the convex hull of IPD using Mahalanobis distance}
\usage{
maicMD(ipd, ad, n.ad = Inf)
}
\arguments{
\item{ipd}{a dataframe with n row and p column, where n is number of subjects and p is the number of variables used in matching.}

\item{ad}{a dataframe with 1 row and p column. The matching variables should be in the same order as that in \code{ipd}. The function does not check this.}

\item{n.ad}{default is Inf assuming \code{ad} is a fixed (known) quantity with infinit accuracy. In most MAIC applications \code{ad} is only the sample statistics and n.ad is known.}
}
\value{
Prints a message whether AD is furthest away from 0, i.e. IPD center in terms of Mahalanobis distance. Also returns ggplot object for plotting.
\item{md.dplot }{dot-plot of AD and IPD in Mahalanobis distance}
\item{md.check }{0 = AD has the largest Mahalanobis distance to the IPD center; 2 = otherwise}
}
\description{
Should only be used when all matching variables are normally distributed
}
\details{
When AD does not have the largest Mahalanobis distance, in the original scale AD can still be outside of the IPD convex hull. On the other hand, when AD does have the largest Mahalanobis distance, in the original scale, AD is for sure outside the IPD convex hull.
}
\examples{
\dontrun{
## eAD[1,] is the scenario A in the reference paper,
## i.e. when AD is perfectly within IPD
md <- maicMD(eIPD, eAD[1,2:3])
md ## a dot-plot of IPD Mahalanobis distances along with AD in the same metric.
}
}
\references{
Glimm & Yau (2021). "Geometric approaches to assessing the numerical feasibility for conducting matching-adjusted indirect comparisons", Pharmaceutical Statistics, 21(5):974-987. doi:10.1002/pst.2210.
}
