% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{dummize_ipd}
\alias{dummize_ipd}
\title{Create dummy variables from categorical variables in an individual patient data (ipd)}
\usage{
dummize_ipd(raw_ipd, dummize_cols, dummize_ref_level)
}
\arguments{
\item{raw_ipd}{ipd data that contains variable to dummize}

\item{dummize_cols}{vector of column names to binarize}

\item{dummize_ref_level}{vector of reference level of the variables to binarize}
}
\value{
ipd with dummized columns
}
\description{
This is a convenient function to convert categorical variables into dummy binary variables.
This would be especially useful if the variable has more than two factors.
Note that the original variable is kept after a variable is dummized.
}
\examples{
data(adsl_twt)
dummize_ipd(adsl_twt, dummize_cols = c("SEX"), dummize_ref_level = c("Male"))

}
