% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapfit.R
\name{mapfit.point}
\alias{mapfit.point}
\title{MAP fitting with point data}
\usage{
mapfit.point(map, x, intervals, ...)
}
\arguments{
\item{map}{An object for MAP. The estimation algorithm is selected depending on this class.}

\item{x}{A vector for point data.}

\item{intervals}{A vector for intervals.}

\item{...}{Further options for fitting methods.}
}
\value{
Returns a list with components, which is an object of S3 class \code{mapfit.result};
\item{model}{an object for estimated PH class.}
\item{llf}{a value of the maximum log-likelihood.}
\item{df}{a value of degrees of freedom of the model.}
\item{aic}{a value of Akaike information criterion.}
\item{iter}{the number of iterations.}
\item{convergence}{a logical value for the convergence of estimation algorithm.}
\item{ctime}{computation time (user time).}
\item{data}{an object for data class}
\item{aerror}{a value of absolute error for llf at the last step of algorithm.}
\item{rerror}{a value of relative error for llf at the last step of algorithm.}
\item{options}{a list of options used for fitting.}
\item{call}{the matched call.}
}
\description{
Estimates MAP parameters from point data.
}
\examples{
## load trace data
data(BCpAug89)
BCpAug89s <- head(BCpAug89, 50)

## MAP fitting for general MAP
(result1 <- mapfit.point(map=map(2), x=cumsum(BCpAug89s)))

## MAP fitting for MMPP
(result2 <- mapfit.point(map=mmpp(2), x=cumsum(BCpAug89s)))

## MAP fitting for ER-HMM
(result3 <- mapfit.point(map=erhmm(3), x=cumsum(BCpAug89s)))

## marginal moments for estimated MAP
map.mmoment(k=3, map=result1$model)
map.mmoment(k=3, map=result2$model)
map.mmoment(k=3, map=result3$model)

## joint moments for estimated MAP
map.jmoment(lag=1, map=result1$model)
map.jmoment(lag=1, map=result2$model)
map.jmoment(lag=1, map=result3$model)

## lag-k correlation
map.acf(map=result1$model)
map.acf(map=result2$model)
map.acf(map=result3$model)

}
