% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_exposed_population_ucdp.R
\name{exposed_population_ucdp}
\alias{exposed_population_ucdp}
\alias{calc_exposed_population_ucdp}
\title{Calculate population exposed to violent conflict from UCDP GED}
\usage{
calc_exposed_population_ucdp(
  distance = 5000,
  violence_types = 1:3,
  years = c(1989:2023),
  precision_location = 1,
  precision_time = 1
)
}
\arguments{
\item{distance}{A numeric vector indicating the buffer size around
included conflict events to calculate the exposed population. Either of
length 1 to apply for all types of events, or discrete values for
each category included in \code{violence_types}.}

\item{violence_types}{A numeric vector indicating the types of violence
to be included (see Details).}

\item{years}{A numeric vector indicating for which years to calculate
the exposed population. Restricted to available years for UCDP GED.
For years not intersecting with available WorldPop layers, the first layer
is used for earlier years and the last layer to more recent years.}

\item{precision_location}{A numeric indicating precision value for the
geolocation up to which events are included. Defaults to 1.}

\item{precision_time}{A numeric indicating the precision value of the
temporal coding up to which events are included. Defaults to 1.}
}
\value{
A function that returns an indicator tibble with conflict exposure
as variable and percentage of the population as its value.
}
\description{
The indicator calculates the population exposed to conflict events within a
specified buffer distance around violent events in UCDP GED. Per default,
the first available WorldPop layer is used to estimate exposed populations
for years before the respective year, while the most recent layer is
used for years after.
}
\details{
The indicator is inspired by the Conflict Exposure tool from ACLED (see
citation below), but differs in the regard that we simply flatten our
buffered event layer instead of applying voronoi tessellation.

The required resources for this indicator are:
\itemize{
\item \link{ucdp_ged}
\item \link{worldpop}
}

You may filter for certain types of violence. The coded types according
to the UCDP codebook are:
value 1: state-based conflict
value 2: non-state conflict
value 3: one-sided conflict

You may apply quality filters based on the precision of the geolocation
of events and the temporal precision. By default, these are set to only
include events with the highest precision scores.

For geo-precision there are levels 1 to 7 with decreasing accuracy:
\itemize{
\item value 1: the location information corresponds exactly to the geographical
coordinates available
\item value 2: the location information refers to a limited area around a
specified location
\item value 3: the source refers to or can be specified to a larger location at
the level of second order administrative divisions (ADM2), such as district
or municipality, the GED uses centroid point coordinates for that ADM2.
\item value 4: the location information refers to a first order administrative
division, such as a province (ADM1), the GED uses the coordinates for the
centroid point of ADM1
\item value 5: is used in different cases if the source refers to parts of a
country which are larger than ADM1, but smaller than the entire country;
if two locations are mentioned a representative point in between is
selected; if the location mentioned is an non-independent island; if
the location is not very specifically mentioned or in relation to another
location
\item value 6: the location mentioned refers to an entire country and its
centroid is used
\item value 7: If the event takes place over water or in international airspace,
the geographical coordinates in the dataset either represent the centroid
point of a certain water area or estimated coordinates
}

For temporal precision there are levels 1 to 5 with decreasing precision:
\itemize{
\item value 1: if the exact date of an event is known
\item value 2: if start and end dates for events are of unspecified character,
spanning more than one calendar day though no longer than six days
\item value 3: if when start and end dates for events are specified to a certain
week, but specific dates are not provided
\item value 4: if start and end dates for events are specified to a certain month
\item value 5: if start and end dates for events are specified to a certain year,
but specific dates are not provided
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
if (FALSE) {
  library(sf)
  library(mapme.biodiversity)

  outdir <- file.path(tempdir(), "mapme-data")
  dir.create(outdir, showWarnings = FALSE)

  mapme_options(
    outdir = outdir,
    verbose = FALSE,
    chunk_size = 1e8
  )

  aoi <- system.file("extdata", "burundi.gpkg",
    package = "mapme.biodiversity"
  ) \%>\%
    read_sf() \%>\%
    get_resources(
      get_ucdp_ged(version = "22.1"),
      get_worldpop(years = 2000)
    ) \%>\%
    calc_indicators(
      conflict_exposure(
        distance = 5000,
        violence_types = 1:3,
        years = 2000,
        precision_location = 1,
        precision_time = 1
      )
    ) \%>\%
    portfolio_long()

  aoi
}
}
}
\references{
Raleigh, C; C Dowd; A Tatem; A Linke; N Tejedor-Garavito; M
Bondarenko and K Kishi. 2023. Assessing and Mapping Global and Local
Conflict Exposure. Working Paper.
}
\keyword{indicator}
