#' \code{masscor}: Mass Measurement Corrections and Uncertainties.
#'
#' The \code{R} package \code{masscor} provides functions, classes and methods
#' to support mass measurements using non automatic balances as described in
#' EURAMET's Calibration Guide No. 18 (2015).
#' The new classes are objects that can store the calibration information for
#' balances and mass standards. Those objects can be used to convert balance readings to
#' both conventional mass and mass, and to perform routine balance verification
#' (by using the normalized error function).
#' Air buoyancy correction factors are calculated using local air density that
#' can be calculated using environmental conditions and applying one
#' of several models available in the package. The uncertainty of (corrected)
#' mass measurements can also be evaluated allowing us to further assess the suitability
#' of given mass measurement.
#'
#' @section \code{masscor} functions:
#' This package uses list objects of class \code{'calibCert'} to store information
#' of balance calibration certificates.
#' The functions use the information of this object to convert balance reading
#' indications to conventional mass and calculate mass
#' uncertainties.
#'
#' Several models for calculating air density are included and this
#' information can be used to calculate the
#' Magnitude of the Air Buoyancy Correction factor (MABC).
#' Uncertainties calculations are made using Gauss Approximation according to the
#' Guide to the Expression of Uncertainty in Measurement (GUM) implemented in
#' \code{R} by the package
#' \link[metRology]{metRology} (Ellison, 2018).
#'
#' @author Cristhian Paredes, \email{craparedesca@@unal.edu.co}
#' @references
#' EURAMET, Calibration Guide No. 18. 2015. Guidelines on the Calibration of
#' Non-Automatic Weighing Instruments.
#' https://www.euramet.org/Media/docs/Publications/calguides/I-CAL-GUI-018_Calibration_Guide_No._18_web.pdf.
#'
#' Picard, A; Davis, R S; Gläser, M; Fujii, K  (2008).  Revised formula for
#' the density of moist air (CIPM-2007).
#' Metrologia, 45(2), 149–155. doi:10.1088/0026-1394/45/2/004
#'
#' Harris, G. (2019). Selected Laboratory and Measurement Practices and Procedures to Support Basic
#' Mass Calibrations. SOP 2 - Recommended Standard Operating Procedure for Applying Air Buoyancy
#' Corrections. National Institute of Standards and Technology (NIST). doi:10.6028/NIST.IR.6969-2019
#'
#' BIMP JCGM (2008) Evaluation of measurement data — Guide to the
#' expression of uncertainty in measurement.
#'
#' Stephen L R Ellison. (2018). metRology: Support for Metrological Applications.
#' R package version 0.9-28-1. https://CRAN.R-project.org/package=metRology
#'
#' @docType package
#' @name masscor-package
NULL
#globalVariables(c('', ''))
