% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_convertMassUnitsSI.R
\name{convertMassUnitsSI}
\alias{convertMassUnitsSI}
\title{Conversion between mass units of The International System of Units}
\usage{
convertMassUnitsSI(value, from, to)
}
\arguments{
\item{value}{numeric vector with the values to be converted.}

\item{from}{character with the unit of original values.}

\item{to}{character with the desired unit for the conversion.}
}
\value{
Numeric vector of mass values converted from a SI unit to another mass unit.
}
\description{
Mass values are converted from a SI unit to another SI unit according to the SI prefixes as
shown in BIMP (2019). The greek letter \eqn{\mu} is replaced by the vocal \code{u}.
}
\examples{
convertMassUnitsSI(value = c(0.2, 0.4), from = 'mg', to = 'g')
}
\references{
BIMP, 2019. Bureau International des Poids et Mesures.
Brochure of The International System of Units. 9th Edition.
}
