% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update_record}
\alias{update_record}
\title{Update Rows in a Data Frame Based on a Condition}
\usage{
update_record(.data, column = NULL, where = NULL, set_to = NULL, ...)
}
\arguments{
\item{.data}{A data frame. The dataset to modify.}

\item{column}{A column in the data frame to update. Can be specified as a column name, index, or unquoted column symbol.}

\item{where}{A condition that determines which rows to update. Must evaluate to a logical vector of the same length as the number of rows in `.data`.}

\item{set_to}{The value to assign to the rows in the specified column where the `where` condition is `TRUE`.}

\item{...}{Additional arguments (currently unused, reserved for future use).}
}
\value{
The modified data frame with updated values.
}
\description{
Modifies the values in a specified column of a data frame for rows that meet a given condition.
}
\details{
This function updates values in a specified column of a data frame for rows that satisfy the given condition.
The `column` parameter can be provided as:
- A numeric column index (e.g., `2`).
- A column name (e.g., `"value"`).
- An unquoted column symbol (e.g., `value`).
}
\examples{
# Example data frame
df <- data.frame(
  id = 1:5,
  value = c(10, 20, 30, 40, 50)
)

# Update rows where id > 3
updated_df <- update_record(df, column = value, where = id > 3, set_to = 100)
print(updated_df)

# Using column as a string
updated_df <- update_record(df, column = "value", where = id == 2, set_to = 99)
print(updated_df)

}
