% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa_operators.R
\name{mutKEdgeExchange}
\alias{mutKEdgeExchange}
\title{k-edge-exchange mutator for edge list representation of spanning trees.}
\usage{
mutKEdgeExchange(ind, k = 1L, instance = NULL)
}
\arguments{
\item{ind}{[\code{matrix(2, m)}]\cr
Matrix of edges (each column is one edge).}

\item{k}{[\code{integer(1)}]\cr
Number of edges to swap.}

\item{instance}{[\code{\link[grapherator]{grapherator}}]\cr
Multi-objective graph.}
}
\description{
Let \eqn{m} be the number of spanning tree edges. Then, the operator
selects \eqn{1 \leq k \leq m} edges randomly and replaces each of the \eqn{k}
edges with another feasible edge.
}
\seealso{
Evolutionary multi-objective algorithm \code{\link{mcMSTEmoaBG}}

Other mcMST EMOA mutators: 
\code{\link{mutEdgeExchange}()},
\code{\link{mutSubforestMST}()},
\code{\link{mutSubgraphMST}()},
\code{\link{mutUniformPruefer}()}
}
\concept{mcMST EMOA mutators}
