% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_gof.R
\name{gof}
\alias{gof}
\title{Measures of Goodness-of-Fit}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.

Wang, M. (2014). Generalized Estimating Equations in Longitudinal Data
Analysis: A Review and Recent Developments. Advances in Statistics, 1(1)1--13.
}
\usage{
gof(object)
}
\arguments{
\item{object}{an object or a list of objects representing a model
of \code{mcglm} class.}
}
\value{
A data frame with the following columns:
\describe{
  \item{plogLik}{Numeric value of the pseudo Gaussian log-likelihood.}
  \item{Df}{Integer giving the number of estimated parameters.}
  \item{pAIC}{Numeric value of the pseudo Akaike Information Criterion.}
  \item{pKLIC}{Numeric value of the pseudo Kullback–Leibler Information Criterion.}
  \item{BIC}{Numeric value of the pseudo Bayesian Information Criterion.}
}
}
\description{
Extract the pseudo Gaussian log-likelihood (plogLik),
pseudo Akaike Information Criterion (pAIC), pseudo Kullback-Leibler
Information Criterion (pKLIC) and pseudo Bayesian Information Criterion (pBIC)
for objects of \code{mcglm} class.
}
\seealso{
\code{plogLik}, \code{pAIC}, \code{pKLIC} and \code{pBIC}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
