% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_anova_disp.R
\name{mc_anova_disp}
\alias{mc_anova_disp}
\title{Wald Tests for Dispersion Components}
\usage{
mc_anova_disp(object, idx_list, names_list, ...)
}
\arguments{
\item{object}{An object of class \code{"mcglm"}, typically the result
of a call to \code{\link{mcglm}}.}

\item{idx_list}{A list of integer vectors indexing dispersion
parameters to be jointly tested for each response.}

\item{names_list}{A list of character vectors with covariate names to
be displayed in the output tables.}

\item{...}{Currently not used.}
}
\value{
The object is a list of data frames, one per response variable. Each
data frame contains the following columns:
\describe{
  \item{Covariate}{Name of the covariate associated with the dispersion
  parameters being tested.}
  \item{Chi.Square}{Wald chi-square test statistic.}
  \item{Df}{Degrees of freedom of the test.}
  \item{p.value}{P-value associated with the chi-square test.}
}
}
\description{
Performs Wald chi-square tests for dispersion (covariance) parameters
by response variable in multivariate covariance generalized linear
models fitted with \code{\link{mcglm}}. This function is intended for
joint hypothesis testing of dispersion coefficients associated with
categorical covariates with more than two levels. It is not designed
for model comparison.
}
\seealso{
\code{\link{mcglm}}, \code{\link{vcov}}, \code{\link{coef}}
}
