% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_robust_std.R
\name{mc_robust_std}
\alias{mc_robust_std}
\title{Robust Standard Errors for Regression Parameters}
\source{
Nuamah, I. F., Qu, Y., and Aminu, S. B. (1996). A SAS macro for stepwise
correlated binary regression. \emph{Computer Methods and Programs in
Biomedicine}, 49, 199--210.
}
\usage{
mc_robust_std(object, id)
}
\arguments{
\item{object}{An object of class \code{mcglm} representing a fitted
marginal model.}

\item{id}{An integer or factor vector identifying clusters or subjects.
Its length and ordering must match the number and ordering of the
observations used to fit the model.}
}
\value{
A list with two components:
\describe{
  \item{Std.Error}{A numeric vector containing the robust standard
  errors of the regression parameter estimates.}
  \item{vcov}{A numeric matrix giving the robust variance--covariance
  matrix of the regression parameter estimates.}
}
The returned objects are computed under the assumption that the data
are in the correct cluster order.
}
\description{
Computes cluster-robust (sandwich-type) standard errors for the
regression parameters of an object of class \code{mcglm}, accounting
for within-cluster correlation.
}
\details{
The robust variance--covariance matrix is obtained using an empirical
estimator based on clustered residuals and the sensitivity matrix of
the estimating equations. The implementation assumes that the data are
correctly ordered such that observations belonging to the same cluster
are stored in contiguous rows.
}
\seealso{
\code{mc_bias_correct_std}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
