% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjugate_gradients.R
\name{CG_control}
\alias{CG_control}
\title{Set options for the conjugate gradient (CG) sampler}
\usage{
CG_control(
  max.it = NULL,
  stop.criterion = NULL,
  preconditioner = c("GMRF", "GMRF2", "GMRF3", "identity"),
  scale = 1,
  chol.control = chol_control(),
  verbose = FALSE
)
}
\arguments{
\item{max.it}{maximum number of CG iterations.}

\item{stop.criterion}{total squared error stop criterion for the CG algorithm.}

\item{preconditioner}{one of  "GMRF", "GMRF2", "GMRF3" and "identity".}

\item{scale}{scale parameter; only used by the "GMRF3" preconditioner.}

\item{chol.control}{options for Cholesky decomposition, see \code{\link{chol_control}}.}

\item{verbose}{whether diagnostic information about the CG sampler is shown.}
}
\value{
A list of options used by the conjugate gradients algorithm.
}
\description{
Set options for the conjugate gradient (CG) sampler
}
