% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/totals.R
\name{trial_totals}
\alias{trial_totals}
\title{Trial Probability and Expected Counts}
\usage{
trial_totals(
  mcmodule,
  mc_names,
  trials_n,
  subsets_n = NULL,
  subsets_p = NULL,
  name = NULL,
  prefix = NULL,
  combine_prob = TRUE,
  all_suffix = NULL,
  level_suffix = c(trial = "trial", subset = "subset", set = "set"),
  mctable = set_mctable(),
  agg_keys = NULL,
  agg_suffix = NULL,
  keep_variates = FALSE,
  summary = TRUE,
  data_name = NULL
)
}
\arguments{
\item{mcmodule}{mcmodule object containing input data and node structure}

\item{mc_names}{Vector of node names to process}

\item{trials_n}{Trial count column name}

\item{subsets_n}{Subset count column name (optional)}

\item{subsets_p}{Subset prevalence column name (optional)}

\item{name}{Custom name for output nodes (optional)}

\item{prefix}{Prefix for output node names (optional)}

\item{combine_prob}{Combine probability of all nodes assuming independence (default: TRUE)}

\item{all_suffix}{Suffix for combined node name (default: "all")}

\item{level_suffix}{A list of suffixes for each hierarchical level (default: c(trial="trial",subset="subset",set="set"))}

\item{mctable}{Data frame containing Monte Carlo nodes definitions (default: set_mctable())}

\item{agg_keys}{Column names for aggregation (optional)}

\item{agg_suffix}{Suffix for aggregated node names (default: "hag")}

\item{keep_variates}{whether to preserve individual values (default: FALSE)}

\item{summary}{Include summary statistics if TRUE (default: TRUE)}

\item{data_name}{Data name used to create trials_n, subsets_n and subsets_p nodes if they don't exist in mcmodule (optional)}
}
\value{
Updated mcmodule object containing:
\itemize{
\item Combined node probabilities
\item Probabilities and counts at trial level
\item Probabilities and counts at subset level
\item Probabilities and counts at set level
}
}
\description{
Calculates probabilities and expected counts across hierarchical levels
(trial, subset, set) in a structured population. Uses trial probabilities and
handles nested sampling with conditional probabilities.
}
\examples{
imports_mcmodule <- trial_totals(
  mcmodule = imports_mcmodule,
  mc_names = "no_detect_a",
  trials_n = "animals_n",
  subsets_n = "farms_n",
  subsets_p = "h_prev",
  mctable = imports_mctable
)
print(imports_mcmodule$node_list$no_detect_a_set$summary)
}
