% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jagscode.R
\encoding{UTF-8}
\name{sd_to_prec}
\alias{sd_to_prec}
\title{Transform a prior from SD to precision.}
\usage{
sd_to_prec(prior_str)
}
\arguments{
\item{prior_str}{String. A JAGS prior. Can be truncated, e.g.
\verb{dt(3, 2, 1) T(my_var, )}.}
}
\value{
A string
}
\description{
JAGS uses precision rather than SD. This function converts
\code{dnorm(4.2, 1.3)} into \code{dnorm(4.2, 1/1.3^2)}. It allows users to specify
priors using SD and then it's transformed for the JAGS code. It works for the
following distributions: dnorm|dt|dcauchy|ddexp|dlogis|dlnorm. In all of
these,
tau/sd is the second parameter.
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
