% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcPiMMDeming.r
\name{mc.mmPidemingConstCV}
\alias{mc.mmPidemingConstCV}
\title{Calculate MM Deming Regression}
\usage{
mc.mmPidemingConstCV(
  X,
  Y,
  error.ratio,
  iter.max = 30,
  threshold = 1e-06,
  priorSlope = 1,
  priorIntercept = 0,
  tauMM = 4.685,
  kM = 1.345
)
}
\arguments{
\item{X}{measurement values of reference method.}

\item{Y}{measurement values of test method.}

\item{error.ratio}{ratio between squared measurement errors of reference- and test method, necessary for Deming regression (Default is 1).}

\item{iter.max}{maximal number of iterations.}

\item{threshold}{threshold value.}

\item{priorSlope}{starting slope value, default priorSlope = 1}

\item{priorIntercept}{starting intercept value, default priorIntercept = 0}

\item{tauMM}{Tukey's tau for bisquare redescending weighting function, default tauMM = 4,685}

\item{kM}{description}
}
\value{
a list with elements
 \item{b0}{intercept.}
 \item{b1}{slope.}
 \item{xw}{average of reference method values.}
 \item{iter}{number of iterations.}
}
\description{
Calculate MM Deming regression with iterative algorithm inspired on the work of Linnet.
The algorithm uses bisquare redescending weights. For maximal stability and convergence
the euclidean residuals are scaled in each iteration with a fresh calculated MAD instead of
keeping the same MAD (assessed at the starting step) for the whole iteration.
This algorithm is available only for positive values. But even in this case there is no guarantee that
the algorithm always converges.
}
\references{
Linnet K.
             Evaluation of Regression Procedures for Methods Comparison Studies.
             CLIN. CHEM. 39/3, 424-432 (1993).

             Linnet K.
             Estimation of the Linear Relationship between the Measurements of two Methods with Proportional Errors.
             STATISTICS IN MEDICINE, Vol. 9, 1463-1473 (1990).
}
