% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{size_one_prop}
\alias{size_one_prop}
\title{Sample Size for Testing One Proportion}
\usage{
size_one_prop(
  p1,
  p0,
  alpha = 0.05,
  power = 0.8,
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{p1}{(\code{numeric})\cr expected criteria of the evaluated assay.}

\item{p0}{(\code{numeric})\cr acceptable criteria of the evaluated assay.}

\item{alpha}{(\code{numeric})\cr type-I-risk, \eqn{\alpha}.}

\item{power}{(\code{numeric})\cr Power of test, equal to 1 minus type-II-risk (\eqn{\beta}).}

\item{alternative}{(\code{string})\cr string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less".}
}
\value{
an object of \code{size} class that contains the sample size and relevant parameters.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function performs sample size computation for testing one proportion
in accordance with Chinese NMPA's IVD guideline.
}
\examples{
size_one_prop(p1 = 0.95, p0 = 0.9, alpha = 0.05, power = 0.8)
}
\references{
Chinese NMPA's IVD technical guideline.
}
\seealso{
\code{\link[=size_ci_one_prop]{size_ci_one_prop()}} \code{\link[=size_corr]{size_corr()}} \code{\link[=size_ci_corr]{size_ci_corr()}}
}
