% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpmap.R
\name{mcpmap}
\alias{mcpmap}
\title{Parallel Map Function using pbapply::pbmapply}
\usage{
mcpmap(
  lists,
  func,
  num_cores = parallel::detectCores() - 1,
  show_progress = TRUE
)
}
\arguments{
\item{lists}{A list of lists containing the parameters for the function.}

\item{func}{The function to be applied.}

\item{num_cores}{The number of cores to use for parallel execution. Default is one less than the total number of available cores.}

\item{show_progress}{Logical indicating whether to display the progress bar. Default is TRUE.}
}
\value{
A list of results from applying the function over the parameters.
}
\description{
This function applies a given function over a list of parameters in parallel using multiple cores.
}
\details{
The function ensures that all elements in the list have the same length and uses `pbapply::pbmapply` for parallel processing.
It sets the number of cores based on the operating system and then applies the function in parallel.
}
\examples{
params <- list(a = 1:3, b = 4:6)
mcpmap(params, function(a, b) a + b, num_cores = 2)
}
