% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classres.R
\name{classres.getPerformance}
\alias{classres.getPerformance}
\title{Calculation of  classification performance parameters}
\usage{
classres.getPerformance(c.ref, c.pred)
}
\arguments{
\item{c.ref}{reference class values for objects (vector with numeric or text values)}

\item{c.pred}{predicted class values for objects (array nobj x ncomponents x nclasses)}
}
\value{
Returns a list with following fields:
\tabular{ll}{
   \code{$fn} \tab number of false negatives (nclasses x ncomponents) \cr
   \code{$fp} \tab number of false positives (nclasses x ncomponents) \cr
   \code{$tp} \tab number of true positives (nclasses x ncomponents) \cr
   \code{$sensitivity} \tab sn values (nclasses x ncomponents) \cr
   \code{$specificity} \tab specificity values (nclasses x ncomponents) \cr
   \code{$specificity} \tab ms ratio values (nclasses x ncomponents) \cr
}
}
\description{
Calculates and returns performance parameters for classification result (e.g. number of false
negatives, false positives, sn, specificity, etc.).
}
\details{
The function is called automatically when a classification result with reference values is
created, for example when applying a \code{plsda} or \code{simca} models.
}
